<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- Output to HTML. HTML elements can't be generated from a malformed input XML  -->
    <xsl:output method="html" encoding="utf-16"/>
    <xsl:template match="/">
        <html>       
            <head>
                <!-- The "<title>" should not be localized. Localize just the data: "Applied Link Translation Mappings" -->
                <ID id="L_SSLT_TITLE"><title>已应用的链接转换映射</title></ID>
                <script type="text/VBScript">
                    sub ViewAllMappings()
                        set rdMainMappingsOnly = document.GetElementById("MainMappingsOnly")
                        set rdAllMappings = document.GetElementById("AllMappings")
                        For Each aTr In document.body.getElementsByTagName("tr") 
                            IsMainMapping = aTr.getAttribute("IsMainMapping")
                            If IsMainMapping = "false" then 
                                if rdMainMappingsOnly.checked = true then
                                    aTr.style.display = "none"
                                else
                                    aTr.style.display = "block"
                                End if		
                            End If
                        next  		        
                    end sub
                </script>
            </head>
            <body>                
                <p><font size="4"><ID id="L_SSLT_Heading">已应用的链接转换映射(规则: </ID><xsl:value-of select="RuleMappings/RuleName"/><ID id="L_SSLT_Bracket">)</ID></font></p>
                <b><ID id="L_SSLT_ViewMode">查看模式:</ID></b> 
                <input type="radio" ID="MainMappingsOnly" name="rdViewMode" onclick="ViewAllMappings()" checked="checked"><ID id="L_SSLT_MainMappings">仅主要映射</ID></input> 
                <input type="radio" ID="AllMappings" onclick="ViewAllMappings()" name="rdViewMode"><ID id="L_SSLT_AllMappings">所有映射</ID></input>
                <xsl:for-each select="RuleMappings/PublicName">
                    <p><font size="3"><b><ID id="L_SSLT_PublicName">公用名称:</ID></b>  <xsl:value-of select="@name"/></font></p>
                    <table border="1">
                        <tr bgcolor="#9acd32">
                            <th align="left"><ID id="L_SSLT_OriginalURL">原始 URL</ID></th>
                            <th align="left"><ID id="L_SSLT_TranslatedURL">转换的 URL</ID></th>
                            <th align="left"><ID id="L_SSLT_MappingDetails">映射详细信息</ID></th>
                            <th align="left"><ID id="L_SSLT_SameWebListener">同一 Web 侦听器</ID></th>
                            <th align="left"><ID id="L_SSLT_CommonDNSSuffix">通用 DNS 后缀</ID></th>
                            <xsl:if test="/RuleMappings/IsaEdition='EE'">
                                <th align="left"><ID id="L_SSLT_ArrayName">阵列名称</ID></th>
                            </xsl:if>	
                        </tr>
                        <xsl:for-each select="Mapping">
                            <tr>
                                <xsl:attribute name="IsMainMapping"><xsl:value-of select="@IsMainMapping"/></xsl:attribute> 
                                <xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute>                                       
                                <td><xsl:value-of select="From"/></td>
                                <td><xsl:value-of select="To"/></td>
                                <td><xsl:value-of select="GeneralDescription"/></td>
                                <xsl:choose>
                                    <xsl:when test="ListenerDescription!='-'">
                                        <td><xsl:value-of select="ListenerDescription"/></td>									
                                    </xsl:when>									
                                    <xsl:otherwise>
                                        <td> </td>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="CommonDnsDescription!='-'">
                                        <td><xsl:value-of select="CommonDnsDescription"/></td>									
                                    </xsl:when>									
                                    <xsl:otherwise>
                                        <td> </td>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:if test="/RuleMappings/IsaEdition='EE'"> 
                                    <xsl:choose>
                                        <xsl:when test="ArrayDescription!='-'">
                                            <td><xsl:value-of select="ArrayDescription"/></td>									
                                        </xsl:when>									
                                        <xsl:otherwise>
                                            <td> </td>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:if>
                            </tr>
                        </xsl:for-each>
                    </table>
                </xsl:for-each>
                <p><font size="3"><ID id="L_SSLT_NOTE">
                <b>注意:</b>
                <p>显示的映射始终会显示 HTTP 协议。但是，如果发布规则中使用的 Web 侦听器也指定了 SSL 连接，此规则的映射将根据请求连接类型(HTTP 或 HTTPS)进行转换。</p>
                <p>对于为链接转换指定附加字符集(除 UTF-8 之外)的规则，某些映射可能在映射表中显示两次。</p>
                </ID></font></p>
                <h4><ID id="L_SSLT_Legend">图例</ID></h4>		
                <ul>
                    <li><ID id="L_SSLT_OriginalURLLegend"><b>原始 URL</b> - 正在搜索的 URL。</ID></li>
                    <li><ID id="L_SSLT_TranslatedURLLegend"><b>转换的 URL</b> - 替换原始 URL 的 URL。</ID></li>
                    <li><ID id="L_SSLT_MappingDetailsLegend"><b>映射详细信息</b> - 指定映射是用户定义的还是规则自动创建的。还指示该映射是应用在规则级别还是阵列级别。</ID></li>
                    <li><ID id="L_SSLT_SameWebListenerLegend"><b>同一 Web 侦听器</b> - 指示两个规则(当前选定的规则和定义映射的规则)是使用同一 Web 侦听器(值 = 是)还是不同的 Web 侦听器(值 = 否)。</ID></li>
                    <li><ID id="L_SSLT_CommonDNSSuffixLegend"><b>通用 DNS 后缀</b> - 发布的 URL 的通用 DNS 后缀。“空”表示 URL 没有任何 DNS 后缀。</ID></li>
                    <xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="/RuleMappings/IsaEdition='EE'"> 
                        <li><ID id="L_SSLT_ArrayNameLegend"><b>阵列名称</b> - 包含所指定映射的规则的阵列名称。“相同”表示两个规则来自同一阵列。</ID></li>
                    </xsl:if>    
                </ul>
            </body> 
        </html>
    </xsl:template>
</xsl:stylesheet>
